/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.placement;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.placement.structure.CreativeStructureHandler;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.util.BlueprintPositionInfo;
import com.ldtteam.structurize.util.PlacementSettings;
import com.ldtteam.structurize.util.TickedWorldOperation;
import net.minecraft.block.AirBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.TriPredicate;
import org.jetbrains.annotations.NotNull;

public class StructurePlacementUtils {
    public static void unloadStructure(@NotNull World world, @NotNull BlockPos startPos, @NotNull String name, Rotation rotation, @NotNull Mirror mirror) {
        CreativeStructureHandler structure = new CreativeStructureHandler(world, startPos, name, new PlacementSettings(mirror, rotation), false);
        structure.getBluePrint().rotateWithMirror(rotation, mirror, world);
        StructurePlacer placer = new StructurePlacer(structure);
        placer.executeStructureStep(world, null, new BlockPos(0, 0, 0), StructurePlacer.Operation.BLOCK_REMOVAL, () -> placer.getIterator().increment((TriPredicate<BlueprintPositionInfo, BlockPos, IStructureHandler>)((TriPredicate)(info, pos, handler) -> handler.getWorld().func_180495_p(pos).func_177230_c() instanceof AirBlock)), true);
    }

    public static void loadAndPlaceStructureWithRotation(World worldObj, @NotNull String name, @NotNull BlockPos pos, Rotation rotation, @NotNull Mirror mirror, boolean fancyPlacement, ServerPlayerEntity player) {
        try {
            CreativeStructureHandler structure = new CreativeStructureHandler(worldObj, pos, name, new PlacementSettings(mirror, rotation), fancyPlacement);
            structure.getBluePrint().rotateWithMirror(rotation, mirror, worldObj);
            StructurePlacer instantPlacer = new StructurePlacer(structure);
            Manager.addToQueue(new TickedWorldOperation(instantPlacer, (PlayerEntity)player));
        }
        catch (IllegalStateException e) {
            Log.getLogger().warn("Could not load structure!", (Throwable)e);
        }
    }

    public static void loadAndPlaceStructureWithRotation(World worldObj, @NotNull Blueprint blueprint, @NotNull BlockPos pos, Rotation rotation, @NotNull Mirror mirror, boolean fancyPlacement, ServerPlayerEntity player) {
        try {
            CreativeStructureHandler structure = new CreativeStructureHandler(worldObj, pos, blueprint, new PlacementSettings(mirror, rotation), fancyPlacement);
            if (fancyPlacement) {
                structure.fancyPlacement();
            }
            structure.getBluePrint().rotateWithMirror(rotation, mirror, worldObj);
            StructurePlacer instantPlacer = new StructurePlacer(structure);
            Manager.addToQueue(new TickedWorldOperation(instantPlacer, (PlayerEntity)player));
        }
        catch (IllegalStateException e) {
            Log.getLogger().warn("Could not load structure!", (Throwable)e);
        }
    }
}

